/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemRenderProperties;

public class ItemArmoredJetpack
extends ItemJetpack
implements IAttributeRefresher {
    private static final ArmoredJetpackMaterial ARMORED_JETPACK_MATERIAL = new ArmoredJetpackMaterial();
    private final AttributeCache attributeCache;

    public ItemArmoredJetpack(Item.Properties properties) {
        super(ARMORED_JETPACK_MATERIAL, properties);
        this.attributeCache = new AttributeCache(this, MekanismConfig.gear.armoredJetpackArmor, MekanismConfig.gear.armoredJetpackToughness, MekanismConfig.gear.armoredJetpackKnockbackResistance);
    }

    @Override
    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(RenderPropertiesProvider.armoredJetpack());
    }

    public int m_40404_() {
        return this.m_40401_().m_7365_(this.m_40402_());
    }

    public float m_40405_() {
        return this.m_40401_().m_6651_();
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, @Nonnull ItemStack stack) {
        return slot == this.m_40402_() ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = f_40380_[this.m_40402_().m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.m_40404_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.m_40405_(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(modifier, "Armor knockback resistance", (double)this.m_40401_().m_6649_(), AttributeModifier.Operation.ADDITION));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ArmoredJetpackMaterial
    extends ItemJetpack.JetpackMaterial {
        private ArmoredJetpackMaterial() {
        }

        @Override
        public int m_7365_(EquipmentSlot slotType) {
            return slotType == EquipmentSlot.CHEST ? MekanismConfig.gear.armoredJetpackArmor.get() : 0;
        }

        @Override
        public String m_6082_() {
            return "mekanism:jetpack_armored";
        }

        @Override
        public float m_6651_() {
            return MekanismConfig.gear.armoredJetpackToughness.get();
        }

        @Override
        public float m_6649_() {
            return MekanismConfig.gear.armoredJetpackKnockbackResistance.get();
        }
    }
}

